var signatures = [	// See: https://en.wikipedia.org/wiki/List_of_file_signatures
	["23 21", "#!", 0, "", "Script or data to be passed to the program following the shebang (#!)."],
	["a1 b2 c3 d4, d4 c3 b2 a1", "¡²ÃÔ, ÔÃ²¡", 0, "pcap", "Libpcap File Format[1]"],
	["0a 0d 0d 0a", "....", 0, "pcapng", "PCAP Next Generation Dump File Format[2]"],
	["ed ab ee db", "í«îÛ", 0, "rpm", "RedHat Package Manager (RPM) package [3]"],
	["53 51 4c 69 74 65 20 66 6f 72 6d 61 74 20 33 00", "SQLite format 3.", 0, "sqlitedb, sqlite, db", "SQLite Database [4]"],
	["53 50 30 31", "SP01", 0, "bin", "Amazon Kindle Update Package [5]"],
	["00", ".", 0, "PIC, PIF, SEA, YTR", "IBM Storyboard bitmap file, Windows Program Information File, Mac Stuffit Self-Extracting Archive, IRIS OCR data file"],
	["BE BA FE CA", "¾ºþÊ", 0, "DBA", "Palm Desktop Calendar Archive"],
	["00 01 42 44", "..BD", 0, "DBA", "Palm Desktop To Do Archive"],
	["00 01 44 54", "..DT", 0, "TDA", "Palm Desktop Calendar Archive"],
	["54 44 46 24", "TDF$", 0, "TDF$", "Telegram Desktop File"],
	["54 44 45 46", "TDEF", 0, "TDEF", "Telegram Desktop Encrypted File"],
	["00 01 00 00", "....", 0, "", "Palm Desktop Data File (Access format)"],
	["00 00 01 00", "....", 0, "ico", "Computer icon encoded in ICO file format[6]"],
	["1F 9D", "..", 0, "z, tar.z", "compressed file (often tar zip), using Lempel-Ziv-Welch algorithm"],
	["1F A0", ".&#160;", 0, "z, tar.z", "Compressed file (often tar zip), using LZH algorithm"],
	["42 41 43 4B 4D 49 4B 45 44 49 53 4B", "BACKMIKE DISK", 0, "bac", "File or tape containing a backup done with AmiBack on an Amiga. It typically is paired with an index file (idx) with the table of contents."],
	["42 5A 68", "BZh", 0, "bz2", "Compressed file using Bzip2 algorithm"],
	["47 49 46 38 37 61", "GIF87a", 0, "gif", "Image file encoded in the Graphics Interchange Format (GIF)[7]"],
	["47 49 46 38 39 61", "GIF89a", 0, "gif", "Image file encoded in the Graphics Interchange Format (GIF)[7]"],
	["49 49 2A 00", "II*.", 0, "tif, tiff", "Tagged Image File Format (little endian format)"],
	["4D 4D 00 2A", "MM.*", 0, "tif, tiff", "Tagged Image File Format (big endian format)"],
	["49 49 2A 00 10 00 00 00 43 52", "II*.....CR", 0, "cr2", "Canon RAW Format Version 2[8], Canon's RAW format is based on the TIFF file format[9]"],
	["80 2A 5F D7", ".*_.", 0, "cin", "Kodak Cineon image"],
	["52 4E 43 01, 52 4E 43 02", "RNC.", 0, "", "Compressed file using Rob Northen Compression (version 1 and 2) algorithm"],
	["53 44 50 58", "SDPX, XPDS", 0, "dpx", "SMPTE DPX image (big endian format)"],
	["58 50 44 53", "SDPX, XPDS", 0, "dpx", "SMPTE DPX image (little endian format)"],
	["76 2F 31 01", "v/1.", 0, "exr", "OpenEXR image"],
	["42 50 47 FB", "BPGû", 0, "bpg", "Better Portable Graphics format[10]"],
	["FF D8 FF DB", "ÿØÿÛ", 0, "jpg, jpeg", "JPEG raw or in the JFIF or Exif file format"],
	["FF D8 FF E0 00 10 4A 46 49 46 00 01", "ÿØÿà..JFIF..", 0, "jpg, jpeg", "JPEG raw or in the JFIF or Exif file format"],
	["FF D8 FF EE", "ÿØÿî", 0, "jpg, jpeg", "JPEG raw or in the JFIF or Exif file format"],
	["FF D8 FF E1 ?? ?? 45 78 69 66 00 00", "ÿØÿá..Exif..", 0, "jpg, jpeg", "JPEG raw or in the JFIF or Exif file format"],
	["46 4F 52 4D ?? ?? ?? ?? 49 4C 42 4D", "FORM...., ILBM", 0, "ilbm, lbm, ibm, iff", "IFF Interleaved Bitmap Image"],
	["46 4F 52 4D?? ?? ?? ?? 38 53 56 58", "FORM...., 8SVX", 0, "8svx, 8sv, svx, snd, iff", "IF", "Amiga Contiguous Bitmap"],
	["46 4F 52 4D?? ?? ?? ?? 41 4E 42 4D", "FORM...., ANBM", 0, "anbm, iff", "IFF Animated Bitmap"],
	["46 4F 52 4D ?? ?? ?? ?? 41 4E 49 4D", "FORM...., ANIM", 0, "anim, iff", "IFF CEL Animation"],
	["46 4F 52 4D?? ?/ ?? ?? 46 41 58 58", "FORM...., FAXX", 0, "faxx, fax, iff", "IFF Facsimile Image"],
	["46 4F 52 4D?? ?/ ?? ?? 46 54 58 54", "FORM...., FTXT", 0, "ftxt, iff", "IFF Formatted Text"],
	["46 4F 52 4D?? ?/ ?? ?? 53 4D 55 53", "FORM...., SMUS", 0, "smus, smu, mus, iff", "IFF Simple Musical Score"],
	["46 4F 52 4D?? ?/ ?? ?? 43 4D 55 53", "FORM...., CMUS", 0, "cmus, mus, iff", "IFF Musical Score"],
	["46 4F 52 4D?? ?/ ?? ?? 59 55 56 4E", "FORM...., YUVN", 0, "yuvn, yuv, iff", "IFF YUV Image"],
	["46 4F 52 4D?? ?/ ?? ?? 46 41 4E 54", "FORM...., FANT", 0, "iff", "Amiga Fantavision Movie"],
	["46 4F 52 4D?? ?/ ?? ?? 41 49 46 46", "FORM...., AIFF", 0, "aiff, aif, aifc, snd, iff", "Audio Interchange File Format"],
	["49 4E 44 58", "INDX", 0, "idx", "Index file to a file or tape containing a backup done with AmiBack on an Amiga."],
	["4C 5A 49 50", "LZIP", 0, "lz", "lzip compressed file"],
	["4D 5A", "MZ", 0, "exe, dll", "DOS MZ executable file format and its descendants (including NE and PE)"],
	["50 4B 03 04", "PK..", 0, "zip, aar, apk, docx, epub, ipa, jar, kmz, maff, odp, ods, odt, pk3, pk4, pptx, usdz, vsdx, xlsx, xpi", "zip file format and formats based on it, such as EPUB, JAR, ODF, OOXML"],
	["50 4B 05 06", "PK..", 0, "zip, aar, apk, docx, epub, ipa, jar, kmz, maff, odp, ods, odt, pk3, pk4, pptx, usdz, vsdx, xlsx, xpi", "zip file format and formats based on it, such as EPUB, JAR, ODF, OOXML"],
	["50 4B 07 08", "PK..", 0, "zip, aar, apk, docx, epub, ipa, jar, kmz, maff, odp, ods, odt, pk3, pk4, pptx, usdz, vsdx, xlsx, xpi", "zip file format and formats based on it, such as EPUB, JAR, ODF, OOXML"],
	["52 61 72 21 1A 07 00", "Rar!...", 0, "rar", "RAR archive version 1.50 onwards[11]"],
	["52 61 72 21 1A 07 01 00", "Rar!....", 0, "rar", "RAR archive version 5.0 onwards[12]"],
	["7F 45 4C 46", ".ELF", 0, "", "Executable and Linkable Format"],
	["89 50 4E 47 0D 0A 1A 0A", ".PNG....", 0, "png", "Image encoded in the Portable Network Graphics format[13]"],
	["CA FE BA BE", "Êþº¾", 0, "class", "Java class file, Mach-O Fat Binary"],
	["EF BB BF", "ï»¿", 0, "UTF-8 with BOM", "UTF-8 encoded Unicode byte order mark, commonly seen in text files."],
	["FE ED FA CE", "........", 0, "", "Mach-O binary (32-bit)"],
	["FE ED FE ED", "þíþí", 0, "", "JKS JavakeyStore"],
	["CE FA ED FE", "........", 0, "", "Mach-O binary (reverse byte ordering scheme, 32-bit)[14]"],
	["CF FA ED FE", "........", 0, "", "Mach-O binary (reverse byte ordering scheme, 64-bit)[14]"],
	["FE FF", "..", 0, "UTF-16 big-endian", "Byte-order mark for text file encoded in big-endian 16-bit Unicode Transfer Format"],
	["FF FE", "..", 0, "UTF-16 little-endian", "Byte-order mark for text file encoded in little-endian 16-bit Unicode Transfer Format"],
	["00 00 FE FF", "....", 0, "UTF-32 big-endian", "Byte-order mark for text file encoded in big-endian 32-bit Unicode Transfer Format"],
	["FF FE 00 00", "....", 0, "UTF-32 little-endian", "Byte-order mark for text file encoded in little-endian 32-bit Unicode Transfer Format"],
	["25 21 50 53", "%!PS", 0, "ps", "PostScript document"],
	["25 50 44 46 2d", "%PDF-", 0, "pdf", "PDF document[15]"],
	["30 26 B2 75 8E 66 CF 11 A6 D9 00 AA 00 62 CE 6C", "0&amp;²u.fÏ.¦Ù.ª.bÎl", 0, "asf, wma, wmv", "Advanced Systems Format[16]"],
	["24 53 44 49 30 30 30 31", "$SDI0001", 0, "", "System Deployment Image, a disk image format used by Microsoft"],
	["4F 67 67 53", "OggS", 0, "ogg, oga, ogv, Ogg", "an open source media container format"],
	["38 42 50 53", "8BPS", 0, "psd", "Photoshop Document file, Adobe Photoshop's native file format"],
	["52 49 46 46 ?? ?? ?? ?? 57 41 56 45", "RIFF...., WAVE", 0, "wav", "Waveform Audio File Format"],
	["52 49 46 46 ?? ?? ?? ?? 41 56 49 20", "RIFF...., AVI.", 0, "avi", "Audio Video Interleave video format"],
	["FF FB", "ÿû", 0, "mp3", "MPEG-1 Layer 3 file without an ID3 tag or with an ID3v1 tag (which's appended at the end of the file)"],
	["49 44 33", "ID3", 0, "mp3", "MP3 file with an ID3v2 container"],
	["42 4D", "BM", 0, "bmp, dib", "BMP file, a bitmap format used mostly in the Windows world"],
	["53 49 4D 50 4C 45 20 20", "SIMPLE  ", 0, "fits", "Flexible Image Transport System (FITS)[18]"],
	["3D 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 54", "=                    T", 0, "fits", "Flexible Image Transport System (FITS)[18]"],
	["66 4C 61 43", "fLaC", 0, "flac", "Free Lossless Audio Codec[19]"],
	["4D 54 68 64", "MThd", 0, "mid, midi", "MIDI sound file[20]"],
	["D0 CF 11 E0 A1 B1 1A E1", "", 0, "doc", "xls, ppt, msg", "Compound File Binary Format, a container format used for document by older versions of Microsoft Office.[21] It is however an open format used by other programs as well."],
	["64 65 78 0A 30 33 35 00", "dex.035.", 0, "dex", "Dalvik Executable"],
	["4B 44 4D", "KDM", 0, "vmdk", "VMDK files[22][23]"],
	["43 72 32 34", "Cr24", 0, "crx", "Google Chrome extension[24] or packaged app[25]"],
	["41 47 44 33", "AGD3", 0, "fh8", "FreeHand 8 document[26][27][28]"],
	["05 07 00 00 42 4F 42 4F 05 07 00 00 00 00 00 00 00 00 00 00 00 01", "....BOBO............", 0, "cwk", "AppleWorks 5 document"],
	["06 07 E1 00 42 4F 42 4F 06 07 E1 00 00 00 00 00 00 00 00 00 00 01", "....BOBO............", 0, "cwk", "AppleWorks 6 document"],
	["45 52 02 00 00 00, 8B 45 52 02 00 00 00", "ER...., ãER....", 0, "toast", "Roxio Toast disc image file, also some .dmg-files begin with same bytes"],
	["78 01 73 0D 62 62 60", "x.s.bb`", 0, "dmg", "Apple Disk Image file"],
	["78 61 72 21", "xar!", 0, "xar", "eXtensible ARchive format[29]"],
	["50 4D 4F 43 43 4D 4F 43", "PMOCCMOC", 0, "dat", "Windows Files And Settings Transfer Repository[30] See also USMT 3.0 (Win XP)[31] and USMT 4.0 (Win 7)[32] User Guides"],
	["4E 45 53 1A", "NES", 0, "nes", "Nintendo Entertainment System ROM file[33]"],
	["74 6F 78 33", "TOX", 0, "tox", "Open source portable voxel file[35]"],
	["4D 4C 56 49", "MLVI", 0, "MLV", "Magic Lantern Video file[36]"],
	["44 43 4D 01 50 41 33 30", "DCM PA30", 0, "", "Windows Update Binary Delta Compression[37]"],
	["37 7A BC AF 27 1C", "7z¼¯'", 0, "7z", "7-Zip File Format"],
	["1F 8B", "..", 0, "gz, tar.gz", "GZIP compressed file[38]"],
	["FD 37 7A 58 5A 00 00", "²7zXZ..", 0, "xz, tar.xz", "XZ compression utility,  using LZMA2 compression"],
	["04 22 4D 18", ".\"M.", 0, "lz4", "LZ4 Frame Format[39], Remark: LZ4 block format does not offer any magic bytes.[40]"],
	["4D 53 43 46", "MSCF", 0, "cab", "Microsoft Cabinet file"],
	["53 5A 44 44 88 F0 27 33", "SZDD....", 0, "Various. (Replacing the last character of the original filename extension with an underscore, e.g. setup.exe becomes setup.ex_)", "Microsoft compressed file in Quantum format, used prior to Windows XP.  File can be decompressed using Extract.exe or Expand.exe distributed with earlier versions of Windows."],
	["46 4C 49 46", "FLIF", 0, "flif", "Free Lossless Image Format"],
	["1A 45 DF A3", ".Eß£", 0, "mkv, mka, mks, mk3d, webm", "Matroska media container, including WebM"],
	["4D 49 4C 20", "MIL ", 0, "stg", "\"SEAN : Session Analysis\" Training file. Also used in compatible software \"Rpw: Rowperfect for Windows\" and \"RP3W : ROWPERFECT3 for Windows\"."],
	["41 54 26 54 46 4F 52 4D ?? ?? ?? ?? 44 4A 56", "AT&TFORM....DJV", 0, "djvu, djv", "DjVu document, The following byte is either 55 (U) for single-page or 4D (M) for multi-page documents."],
	["30 82", "0.", 0, "der", "DER encoded X.509 certificate"],
	["77 4F 46 46", "wOFF", 0, "woff", "WOFF File Format 1.0"],
	["77 4F 46 32", "wOF2", 0, "woff2", "WOFF File Format 2.0"],
	["3c 3f 78 6d 6c 20", "<?xml ", 0, "XML", "eXtensible Markup Language when using the ASCII character encoding"],
	["00 61 73 6d", ".asm", 0, "wasm", "WebAssembly binary format[41]"],
	["cf 84 01", "", 0, "lep", "Lepton compressed JPEG image[42]"],
	["43 57 53", "CWS", 0, "swf", "flash .swf"],
	["46 57 53", "FWS", 0, "swf", "flash .swf"],
	["21 3C 61 72 63 68 3E", "!<arch>.", 0, "deb", "linux deb file"],
	["52 49 46 46 ?? ?? ?? ?? 57 45 42 50", "RIFF....WEBP", 0, "webp", "Google WebP image file"],
	["27 05 19 56", "'..V", 0, "", "U-Boot / uImage. Das U-Boot Universal Boot Loader.[43]"],
	["7B 5C 72 74 66 31", "{\rtf1", 0, "rtf", "Rich Text Format"],
	["54 41 50 45", "TAPE", 0, "", "Microsoft Tape Format"],
	["47", "G", 0, "ts, tsv, tsa", "MPEG Transport Stream  (MPEG-2 Part 1)"],
	["00 00 01 BA", "....", 0, "m2p, vob", "MPEG Program Stream  (MPEG-1 Part 1 (essentially identical) and MPEG-2 Part 1)"],
	["00 00 01 BA", "....", 0, "mpg, mpeg", "MPEG Program Stream, MPEG Transport Stream, MPEG-1 video and MPEG-2 video  (MPEG-1 Part 2 and MPEG-2 Part 2)"],
	["47", "G", 0, "mpg, mpeg", "MPEG Program Stream, MPEG Transport Stream, MPEG-1 video and MPEG-2 video  (MPEG-1 Part 2 and MPEG-2 Part 2)"],
	["00 00 01 B3", "....", 0, "mpg, mpeg", "MPEG Program Stream, MPEG Transport Stream, MPEG-1 video and MPEG-2 video  (MPEG-1 Part 2 and MPEG-2 Part 2)"],
	["78 01", "....", 0, "zlib", "No Compression/low, Default Compression, Best Compression"],
	["78 9C", "....", 0, "zlib", "No Compression/low, Default Compression, Best Compression"],
	["78 DA", "....", 0, "zlib", "No Compression/low, Default Compression, Best Compression"],
	["62 76 78 32", "bvx2", 0, "lzfse", "LZFSE - Lempel-Ziv style data compression algorithm using Finite State Entropy coding. OSS by Apple.[44]"],
	["4F 52 43", "ORC", 0, "orc", "Apache ORC (Optimized Row Columnar) file format"],
	["4F 62 6A 01", "Obj.", 0, "avro", "Apache Avro binary file format"],
	["53 45 51 36", "SEQ6", 0, "rc", "RCFile columnar file format"],
	["65 87 78 56", "e.xV", 0, "p25, obt", "PhotoCap Object Templates"],
	["55 55 aa aa", "UU¬¬", 0, "pcv", "PhotoCap Vector"],
	["78 56 34", "xV4", 0, "pbt, pdt, pea, peb, pet, pgt, pict, pjt, pkt, pmt", "PhotoCap Template"],
	["50 41 52 31", "PAR1", 0, "", "Apache Parquet columnar file format"],
	["45 4D 58 32", "EMX2", 0, "ez2", "Emulator Emaxsynth samples"],
	["45 4D 55 33", "EMU3", 0, "ez3, iso", "Emulator III synth samples"],
	["1B 4C 75 61", ".Lua", 0, "luac", "Lua bytecode[45]"],
	["62 6F 6F 6B 00 00 00 00 6D 61 72 6B 00 00 00 00", "book....mark....", 0, "alias", "macOS file Alias[46] (Symbolic link)"],
	["5B 5A 6F 6E 65 54 72 61 6E 73 66 65 72 5D", "[ZoneTransfer]", 0, "Identifier", "Microsoft Zone Identifier for URL Security Zones[47]"],
	["52 65 63 65 69 76 65 64", "Received:", 0, "eml", "Email Message var5[48]"],
	["20 02 01 62 A0 1E AB 07 02 00 00 00", " ..b&#160;.«.....", 0, "tde", "Tableau Datasource"],
	["37 48 03 02 00 00 00 00 58 35 30 39 4B 45 59", "7H......X509KEY", 0, "kdb", "KDB file"],
	["28 B5 2F FD", "(µ/ý", 0, "zst", "Zstandard compressed file[49][50]"],
	["3A 29 0A", ":).", 0, "sml", "Smile file"],
	["FE ED FA CF", "........", 0, "", "Mach-O binary (64-bit)"],
	// signatures not at 0 address in file
	["66 74 79 70 33 67", "ftyp3g", 4, "3gp, 3g2", "3rd Generation Partnership Project 3GPP and 3GPP2 multimedia files"],
	["00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00", "........................", 11, "PDB", "PalmPilot Database/Document File"],
	["44 49 43 4D", "DICM", 0x80, "dcm", "DICOM Medical File Format"],
	["47", "G", 0xBC, "ts, tsv, tsa", "MPEG Transport Stream  (MPEG-2 Part 1)"],
	["75 73 74 61 72 00 30 30, 75 73 74 61 72 20 20 00", "ustar.00, ustar  .", 0x101, "tar", "tar archive[34]"],
	["47", "G", 0x178, "ts, tsv, tsa", "MPEG Transport Stream  (MPEG-2 Part 1)"]
/*
	["FE ED FA CE", "........", 0x1000, "", "Mach-O binary (32-bit)"],
	["FE ED FA CF", "........", 0x1000, "", "Mach-O binary (64-bit)"],
	["43 44 30 30 31", "CD001", 0x8001, "iso", "ISO9660 CD/DVD image file[17]"],
	["43 44 30 30 31", "CD001", 0x8801, "iso", "ISO9660 CD/DVD image file[17]"],
	["43 44 30 30 31", "CD001", 0x9001, "iso", "ISO9660 CD/DVD image file[17]"]
*/
];
